;| acmZahlInnerhalbTextndern

Addiert (oder subtrahiert) eine Zahl zu einer Zahl innerhalb von Texten und MTexten


Plattform: ab AutoCAD 2024
Copyright
Markus Hoffmann, www.CADmaro.de

Januar 2025
|;
(defun c:acmZahlInnerhalbTextndern (/ ss iOp s i iNumber sNew sNumb c sRest sOld)
  (mx:Init)
  (if (setq ss (ssget '((0 . "*TEXT"))))
    (progn
      (initget 1)
      (setq iOp
             (getint
               "\nWieviel soll addiert oder subtrahiert (negatives Vorzeichen!) werden: "
             )
      )
      (foreach lText (mapcar 'entget (mx:SelectionSet->EList ss))
        (if
          (and
            (setq s (cdr (assoc 1 lText)))
            ;; ---------------------------------------------------------------------
            ;; Fr komplexere Buchstaben-Zahlen-Kombinationen, kann diese auskommentierte Variante verwendet werden.
            ;; Sie funktioniert fr mehrere Zahlencodes innerhalb eines Textstrings.
            ;; Die Auswahl erfolgt dann ber eine Abfrage beim User nach der laufenden Nummer des Eintrags:

            ;;	    (setq i (mx:ListAskSequenceItem s)

            ;;----------------------------------------------------------------------
            (setq iNumber
                   (
                    last
                     ;; ---------------------------------------------------------------------
                     ;; um o.g. Variante scharf zu stellen, "last" auskommentieren und
                     ;; die beiden nchsten Zeilen entkommentieren

                     ;;                    nth
                     ;;                     (1- i)
                     ;; ---------------------------------------------------------------------
                     (LM:parsenumbers s)
                   )
            )
          )
           (progn
             (setq sNew
                    (if
                      ;; Problem Nachkommastellen in REAL
                      (=
                        'REAL
                        (type iNumber)
                      )
                       (progn
                         (setq sNumb
                                (vl-princ-to-string iNumber)
                         )              ; aus Zahl String machen
                         (setq c
                                (vl-string-search sNumb s)
                         )              ; Position der Zahl in Gesamstring
                         (strcat
                           (vl-princ-to-string (+ iNumber iOp))
                           (setq sRest
                                  (substr s
                                          (+
                                            c
                                            (strlen
                                              (substr s c (1+ (strlen sNumb)))
                                            )
                                          )
                                  )
                           )            ; Reststring nach Zahl
                         )
                       )
                       (itoa (+ iNumber iOp))  ; bei INT einfahc hochzhlen
                    )
             )
             (setq sOld
                    (if
                      ;; Problem Nachkommastellen in REAL
                      (=
                        'REAL
                        (type iNumber)
                      )
                       (strcat
                         (vl-princ-to-string iNumber)
                         sRest
                       )
                       (itoa iNumber)
                    )
             )
             (entmod
               (subst
                 (cons 1
                       (str-subst
                         s
                         sNew
                         sOld
                       )
                 )
                 (assoc 1 lText)
                 lText
               )
             )
           )
        )
      )
    )
  )
  (mx:Reset)
  (princ)
)

 ;|Weitere Textobjekte?
'(
  "AcDbAttribute" - TextString
   "AcDbAttributeDefinition" - Tagstring
   "AcDbMText" - TextString
   "AcDbText" - TextString
   "AcDbLeader" - TextString
   "AcDbMLeader" - TextString
   )
         |;

 ;| mx:SelectionSet->EList

Auswahlsatz in Liste umwandeln
|;
(defun mx:SelectionSet->EList (ss / c lst)
  (repeat
    (setq c (sslength ss))
     (setq lst
            (cons
              (ssname ss (setq c (1- c)))
              lst
            )
     )
  )
)

 ;| str-subst

Teile eines Strings ersetzen
|;
(defun str-subst (str neu alt / i la str2)
  (setq i 1)
  (setq la (strlen alt))
  (setq str2 "")
  (while (<= i (strlen str))
    (if
      (= (substr str i la) alt)
       (progn
         (setq str2 (strcat str2 neu))
         (setq i (+ i la))
       )
       (progn
         (setq str2 (strcat str2 (substr str i 1)))
         (setq i (1+ i))
       )
    )
  )
  str2
)

;; Parse Numbers  -  Lee Mac
;; Parses a list of numerical values from a supplied string.
(defun LM:parsenumbers (str)
  ((lambda (l)
     (read
       (strcat
         "("
         (vl-list->string
           (mapcar
             '(lambda (a b c)
                (if (or (< 47 b 58)
                        (and (= 45 b) (< 47 c 58) (not (< 47 a 58)))
                        (and (= 46 b) (< 47 a 58) (< 47 c 58))
                    )
                  b
                  32
                )
              )
             (cons nil l)
             l
             (append (cdr l) '(()))
           )
         )
         ")"
       )
     )
   )
    (vl-string->list str)
  )
)

 ;| mx:ListAskSequenceItem
Die laufende Nummer einer Zahl innerhalb einer Liste abfragen
|;
(defun mx:ListAskSequenceItem (s / l i)
  (if
    (> (length (setq l (LM:parsenumbers s))) 1)
     (progn
       (initget 7)
       (setq i
              (getint
                (strcat
                  "\nMehrere Zahlen im Text gefunden. Bitte die laufende Nummer der zu ersetzenden Zahl eingeben: "
                  (vl-princ-to-string l)
                  ": "
                )
              )
       )
     )
  )
  i
)

 ;| mx:Init

Initialisierung
|;
(defun mx:Init ()
  (vl-load-com)
  (setq oA (vlax-get-acad-object))
  (setq oAD
         (vlax-get-property
           oA
           'ActiveDocument
         )
  )
  (setq iECHO (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq errorMX *error*
        *error* mx:Error
  )
  (vlax-invoke-method oAD 'EndUndomark)
  (vlax-invoke-method oAD 'StartUndomark)
)

 ;| mx:Reset

Zurcksetzen
|;
(defun mx:Reset ()
  (setvar "CMDECHO" iECHO)
  (vlax-invoke-method oAD 'EndUndomark)
  (vlax-release-object oAD)
  (vlax-release-object oA)
  (setq *error* errorMX)
  (mapcar
    '(lambda (arg)
       (set
         arg
         'nil
       )
     )
    (list 'errorMX 'iEcho 'oAD 'oA)
  )
)

 ;| mx:Error

Errorfunktion
|;
(defun mx:Error (s)
  (print (strcat "Fehler " s))
  (command-s)
  (command-s "_.undo" "_back")
  (mx:Reset)
  (princ)
)

;;; Kurzbefehl
(defun c:acmZITAE () (c:acmZahlInnerhalbTextndern))

;; Feedback beim Laden
(princ
  "\nacmZahlInTextndern.lsp wurde geladen. Copyright M.Hoffmann, www.CADmaro.de.
Start mit \"acmZIT\" oder \"acmZahlInnerhalbTextndern\"."
)